/*
	CCube.h
	
	Author:	Ivan Pinzon, iPinSoft
	Description:	Single cube: 
					these are used to create the rubik cube

	Creation Date:	Jan. 12/05
	Last Update:	Jan. 12/05
*/

// $Source: /Volumes/Code/CVS/IPA/Graphics/OpenGL/Rubik/CCube.h,v $
// $Revision: 1.4 $
// $Date: 2005/02/09 17:34:48 $
// $Author: ivanp $


#include <GLUT/glut.h>
#include <vector>

using namespace std;

class CCube
{
public:
	enum
	{
		kFrontFace,
		kRightFace,
		kBackFace,
		kLeftFace,
		kTopFace,
		kBottomFace,
		kXFace, // middle faces
		kYFace,
		kZFace
	};
	
	struct FaceColorT
	{
		GLfloat red;
		GLfloat green;
		GLfloat blue;
	};
	typedef struct FaceColorT FaceColorT;
	
	CCube(GLfloat inFaceSize);
	virtual ~CCube();
	
	virtual void initCube();
	virtual void setCenter(const GLfloat inX, const GLfloat inY, const GLfloat inZ);
	virtual void setFaceTexture(const int inIndex, GLubyte *inTextureP);
	virtual void setFaceColor(const int inIndex, FaceColorT inFaceColor);
	virtual void clearRotations();
	
	virtual void drawCube(bool inUseTexture);
	virtual void drawFacesWithTextures(GLfloat inX, GLfloat inY, GLfloat inZ, GLfloat inInsetFaceSize);
	virtual void drawFacesWithColors(GLfloat inX, GLfloat inY, GLfloat inZ, GLfloat inInsetFaceSize);
	virtual void rotate(GLfloat inAngle, GLfloat inX, GLfloat inY, GLfloat inZ, bool inSaveRotation = true);

long mID;

protected:

private:
	struct rotationT
	{
		GLfloat angle;
		GLfloat x;
		GLfloat y;
		GLfloat z;
		bool saveRotation;
	};
	typedef struct rotationT rotationT;

	GLfloat				mFaceSize;
	GLfloat				mCenterX, mCenterY, mCenterZ;
	FaceColorT			mFaceColorsA[6];	
	GLubyte				*mFaceTexturesA[6];
	vector<rotationT>	mRotationV;
};

#define __NewFaceColor(var, inRed, inGreen, inBlue)  CCube::FaceColorT var; var.red = inRed; var.green = inGreen; var.blue = inBlue;

